###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )

# Add Trinity location for pkg-config files
set( ENV{PKG_CONFIG_PATH} "$ENV{PKG_CONFIG_PATH}:${PKGCONFIG_INSTALL_DIR}")


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for pthread

find_package ( Threads REQUIRED )


##### check for system SQLite3

if( WITH_LOCAL_SQLITE3 )
  set( SQLITE3_INCLUDE_DIRS ${CMAKE_SOURCE_DIR}/src/libs/sqlite3 )
  set( SQLITE3_LIBRARIES sqlite3-static )
else()
  pkg_search_module( SQLITE3 sqlite3 )
  if( NOT SQLITE3_FOUND )
    tde_message_fatal( "SQLite3 is required but not found on your system" )
  endif( )
endif()


##### check for lcms

check_include_file( lcms.h HAVE_LCMS_H )
if( HAVE_LCMS_H )
  pkg_search_module( LCMS lcms )
  set( LCMS_HEADER lcms.h )
else()
  tde_message_fatal( "lcms is requireq but was not found on your system" )
endif()


##### check for libexiv2

pkg_search_module( KEXIV2 libkexiv2 )
if( NOT KEXIV2_FOUND )
  tde_message_fatal( "libkexiv2 is required but was not found on your system" )
endif( NOT KEXIV2_FOUND )


##### check for libjpeg

find_package( JPEG )
if( NOT JPEG_FOUND )
  tde_message_fatal( "libjpeg is required but was not found on your system" )
endif()


##### checks for libpeg2000

find_package( Jasper )
if( NOT JASPER_FOUND )
  tde_message_fatal( "libjasper is required but not found on your system" )
endif( )


##### check for libkdcraw

pkg_search_module( KDCRAW libkdcraw )
if( NOT KDCRAW_FOUND )
  tde_message_fatal( "libkdcraw is required but not found on your system" )
endif( )


##### check for libkipi

pkg_search_module( KIPI libkipi )
if( NOT KIPI_FOUND )
  tde_message_fatal( "libkipi is requireq but not found on your system" )
endif( )


##### check for libgphoto2

pkg_search_module( GPHOTO2 libgphoto2 )
if( NOT GPHOTO2_FOUND )
  tde_message_fatal( "libgphoto2 is required but not found on your system" )
endif( )

check_library_exists(gphoto2_port gp_port_info_get_name "" GPHOTO2_5)
if( GPHOTO2_5 )
  message(STATUS "  found libgphoto2 2.5")
  set( HAVE_GPHOTO25 1 )
else( )
  message(STATUS "  assuming libgphoto2 2.4")
endif( )


##### check for libpng

find_package( PNG )
if( NOT PNG_FOUND )
  tde_message_fatal( "libpng is required but was not found on your system" )
endif()


##### checks for libtiff

pkg_search_module( TIFF libtiff-4 )
if( NOT TIFF_FOUND )
  find_package( TIFF )
endif( )
if( NOT TIFF_FOUND )
  tde_message_fatal( "libtiff is required but not found on your system" )
endif( )
