/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-02-14
 * Description : a simple widget to choose a font based on
 *               KDE FontChooserWidget implementation.
 *
 * Copyright (C) 2005-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright (C) 1999      by Preston Brown <pbrown@kde.org>
 * Copyright (C) 1997      by Bernd Johannes Wuebben <wuebben@kde.org>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef FONT_CHOOSER_WIDGET_H
#define FONT_CHOOSER_WIDGET_H

#include <tqlineedit.h>
#include <tqbutton.h>

class TQComboBox;
class TQCheckBox;
class TQFont;
class TQGroupBox;
class TQLabel;
class TQStringList;

class TDEListBox;
class KIntNumInput;

namespace DigikamInsertTextImagesPlugin
{

class FontChooserWidget : public TQWidget
{
  TQ_OBJECT
  
  TQ_PROPERTY( TQFont font READ font WRITE setFont )

public:

    enum FontColumn
    {
       FamilyList=0x01,
       StyleList=0x02,
       SizeList=0x04
    };

    enum FontDiff
    {
       FontDiffFamily=0x01,
       FontDiffStyle=0x02,
       FontDiffSize=0x04
    };

    enum FontListCriteria
    {
       FixedWidthFonts=0x01,
       ScalableFonts=0x02,
       SmoothScalableFonts=0x04
    };

public:

    FontChooserWidget(TQWidget *parent = 0L, const char *name = 0L,
                      bool onlyFixed = false,
                      const TQStringList &fontList = TQStringList(),
                      int visibleListSize=8,
                      bool diff = false,
                      TQButton::ToggleState *sizeIsRelativeState = 0L );

    ~FontChooserWidget();

    void setFont( const TQFont &font, bool onlyFixed = false );
    void setColor( const TQColor & col );
    void setBackgroundColor( const TQColor & col );
    void setSizeIsRelative( TQButton::ToggleState relative );

    TQFont font() const { return selFont; };
    TQColor color() const;
    TQColor backgroundColor() const;
    static void getFontList( TQStringList &list, uint fontListCriteria);
    TQButton::ToggleState sizeIsRelative() const;
    static TQString getXLFD( const TQFont &theFont ) { return theFont.rawName(); };

    int fontDiffFlags();
    void enableColumn( int column, bool state );
    virtual TQSize sizeHint( void ) const;

signals:

    void fontSelected( const TQFont &font );

private slots:

    void toggled_checkbox();
    void family_chosen_slot(const TQString&);
    void size_chosen_slot(const TQString&);
    void style_chosen_slot(const TQString&);
    void displaySample(const TQFont &font);
    void showXLFDArea(bool);
    void size_value_slot(int);

private:

    void fillFamilyListBox(bool onlyFixedFonts = false);
    void fillSizeList();

    void addFont( TQStringList &list, const char *xfont );

    void setupDisplay();

    int minimumListWidth( const TQListBox *list );
    int minimumListHeight( const TQListBox *list, int numVisibleEntry );

private:

    bool                    usingFixed;
    int                     selectedSize;

    TQMap<TQString, TQString>  currentStyles;

    // pointer to an optinally supplied list of fonts to
    // inserted into the fontdialog font-family combo-box
    TQStringList             fontList;

    TQLineEdit              *xlfdEdit;

    TQLabel                 *familyLabel;
    TQLabel                 *styleLabel;

    TQCheckBox              *familyCheckbox;
    TQCheckBox              *styleCheckbox;
    TQCheckBox              *sizeCheckbox;
    TQCheckBox              *sizeIsRelativeCheckBox;

    TQComboBox              *charsetsCombo;

    TQFont                   selFont;

    TQString                 selectedStyle;

    TQLabel                 *sizeLabel;

    KIntNumInput           *sizeOfFont;

    TDEListBox               *familyListBox;
    TDEListBox               *styleListBox;
    TDEListBox               *sizeListBox;

private:

    class FontChooserWidgetPrivate;
    FontChooserWidgetPrivate *d;

};

}  // NameSpace DigikamInsertTextImagesPlugin

#endif // FONT_CHOOSER_WIDGET_H
