/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-09-16
 * Description : Camera interface dialog
 *
 * Copyright (C) 2004-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2009 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef CAMERAUI_H
#define CAMERAUI_H

// TQt includes.

#include <tqdatetime.h>
#include <tqstring.h>
#include <tqimage.h>

// KDE includes.

#include <kdialogbase.h>
#include <kurl.h>

// Local includes.

#include "gpiteminfo.h"

namespace Digikam
{

class Album;
class CameraIconViewItem;
class CameraUIPriv;

class CameraUI : public KDialogBase
{
    TQ_OBJECT
  

public:

    CameraUI(TQWidget* parent, const TQString& cameraTitle,
             const TQString& model, const TQString& port,
             const TQString& path, const TQDateTime lastAccess);
    ~CameraUI();

    bool isBusy() const;
    bool isClosed() const;

    bool autoRotateJpegFiles() const;

    /** Get status of JPEG conversion files to lossless format during download.*/
    bool convertLosslessJpegFiles() const;
    TQString losslessFormat();

    TQString cameraTitle() const;

signals:

    void signalLastDestination(const KURL&);
    void signalAlbumSettingsChanged();

public slots:

    void slotDownload(bool onlySelected, bool deleteAfter, Album *album=0);

protected:

    void closeEvent(TQCloseEvent* e);
    void keyPressEvent(TQKeyEvent *e);

private:

    void readSettings();
    void saveSettings();
    bool dialogClosed();
    bool createAutoAlbum(const KURL& parentURL, const TQString& sub,
                         const TQDate& date, TQString& errMsg);
    void addFileExtension(const TQString& ext);
    void finishDialog();
    void deleteItems(bool onlySelected, bool onlyDownloaded);
    void checkItem4Deletion(CameraIconViewItem* iconItem, TQStringList& folders, TQStringList& files,
                            TQStringList& deleteList, TQStringList& lockedList);

private slots:

    void slotClose();
    void slotCancelButton();
    void slotProcessURL(const TQString& url);

    void slotConnected(bool val);
    void slotBusy(bool val);
    void slotErrorMsg(const TQString& msg);
    void slotInformations();
    void slotCameraInformations(const TQString&, const TQString&, const TQString&);

    void slotFolderList(const TQStringList& folderList);
    void slotFileList(const GPItemInfoList& fileList);
    void slotThumbnail(const TQString&, const TQString&, const TQImage&);

    void slotIncreaseThumbSize();
    void slotDecreaseThumbSize();

    void slotUpload();
    void slotUploadItems(const KURL::List&);
    void slotDownloadSelected();
    void slotDownloadAll();
    void slotDeleteSelected();
    void slotDownloadAndDeleteSelected();
    void slotDeleteAll();
    void slotDownloadAndDeleteAll();
    void slotToggleLock();

    void slotFileView(CameraIconViewItem* item);

    void slotUploaded(const GPItemInfo&);
    void slotDownloaded(const TQString&, const TQString&, int);
    void slotSkipped(const TQString&, const TQString&);
    void slotDeleted(const TQString&, const TQString&, bool);
    void slotLocked(const TQString&, const TQString&, bool);

    void slotNewSelection(bool);
    void slotItemsSelected(CameraIconViewItem* item, bool selected);

    void slotExifFromFile(const TQString& folder, const TQString& file);
    void slotExifFromData(const TQByteArray& exifData);

    void slotFirstItem(void);
    void slotPrevItem(void);
    void slotNextItem(void);
    void slotLastItem(void);

private:

    CameraUIPriv* d;
};

}  // namespace Digikam

#endif /* CAMERAUI_H */
