/*
 * pref.h
 *
 * Copyright (C) 2004-2005 Jürgen Kofler <kaffeine@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef PREF_H
#define PREF_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqtoolbutton.h>

#include <kdialogbase.h>

class TQCheckBox;
class TQSpinBox;
class TQComboBox;
class TQLineEdit;

class KaffeinePreferences : public KDialogBase
{
    TQ_OBJECT
  

public:
  KaffeinePreferences();
  virtual ~KaffeinePreferences() {}

  void setConfig(bool pauseVideo, bool tray, uint duration, bool useEncoding, const TQString& encoding);
  void setDvbClient( bool enabled, const TQString &address, int port, int info, const TQString &tspath );

signals:
  void signalClearRecent();
  void signalEmbedSystemTray(bool);
  void signalUseAlternateEncoding(bool);
  void signalAlternateEncoding(const TQString&);
  void signalSetOSDTimeout(uint);
  void signalPauseVideo(bool);
  void signalDvbClient(bool,const TQString&,int,int,const TQString&);

private slots:
  void slotOkPressed();
  void slotApplyPressed();
  void slotUseAlternateEncodingToggled(bool);
  void slotEmbedInTrayToggled(bool);
  void setShiftDir();

private:
  TQCheckBox* m_systemTray;
  TQSpinBox* m_osdTimeout;
  TQCheckBox* m_useAlternateEncoding;
  TQComboBox* m_alternateEncoding;
  TQCheckBox* m_pauseVideo;
  TQCheckBox* m_dcEnabled;
  TQLineEdit* m_dcAddress;
  TQSpinBox* m_dcPort;
  TQSpinBox* m_dcInfo;
  TQLineEdit *m_shiftDirLe;
  TQToolButton *m_shiftDirBtn;
};

#endif /* PREF_H */
