/***************************************************************************
 *   Copyright (C) 2005-2006 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "pfile.h"

#include <tqfile.h>

//-----------------------------------------------------------------------------
PURL::FileBase::FileBase(Log::Generic &log, const TQString &extension)
  : _tmp(0), _file(0), _stream(0), _extension(extension), _log(log)
{}

PURL::FileBase::~FileBase()
{
  delete _stream;
  delete _file;
  delete _tmp;
}

const TQFile *PURL::FileBase::qfile() const
{
  return (_tmp ? _tmp->file() : _file);
}

TQFile *PURL::FileBase::qfile()
{
  return (_tmp ? _tmp->file() : _file);
}

void PURL::FileBase::flush()
{
  if ( qfile() ) qfile()->flush();
}

TQTextStream &PURL::FileBase::stream()
{
  if ( _stream==0 ) _stream = new TQTextStream(qfile());
  return *_stream;
}

bool PURL::FileBase::hasError() const
{
  if ( qfile()==0 || !_error.isEmpty() ) return true;
  return ( uint(qfile()->status())!=IO_Ok );
}

TQString PURL::FileBase::errorString() const
{
  if ( _error.isEmpty() ) {
    if ( qfile()==0 ) return i18n("File not open.");
    else return qfile()->errorString();
  }
  return _error;
}

TQStringList PURL::FileBase::readLines()
{
  TQStringList lines;
  for (;;) {
    TQString s = stream().readLine();
    if ( s.isNull() ) break;
    lines.append(s);
  }
  return lines;
}

TQByteArray PURL::FileBase::readAll()
{
  if ( qfile() ) return qfile()->readAll();
  return TQByteArray();
}

//-----------------------------------------------------------------------------
PURL::File::File(const Url &url, Log::Generic &log)
  : FileBase(log, TQString()), _url(url)
{
  _file = new TQFile;
}

void PURL::File::setUrl(const Url &url)
{
  close();
  _url = url;
}
