/***************************************************************************
 *   Copyright (C) 2005-2006 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef DEVICE_GROUP_H
#define DEVICE_GROUP_H

#if !defined(NO_KDE)
#  include <tqcolor.h>
#endif

#include "generic_device.h"
#include "common/common/group.h"
#include "common/common/streamer.h"
namespace Debugger { class DeviceSpecific; class Base; }

namespace Device
{
class Memory;

//----------------------------------------------------------------------------
class MemoryRange {
public:
  MemoryRange() {}
  virtual ~MemoryRange() {}
  virtual bool all() const { return true; }
};

//----------------------------------------------------------------------------
class GroupBase : public ::Group::Base
{
public:
  virtual Memory *createMemory(const Device::Data &data) const = 0;
  virtual TQString informationHtml(const Device::Data &data) const = 0;
#if !defined(NO_KDE)
  virtual TQPixmap memoryGraph(const Device::Data &data) const = 0;
#endif

protected:
  virtual void addDevice(const TQString &name, const Device::Data *data, ::Group::Support support) {
    const_cast<Device::Data *>(data)->_group = this;
    ::Group::Base::addDevice(name, data, support);
  }
};

template <class DataType>
class Group : public GroupBase, public DataStreamer<DataType>
{
protected:
  virtual void initSupported() {
    TQValueList<DataType *> list = this->fromCppString(dataStream(), dataSize());
    for (uint i=0; i<uint(list.count()); i++) addDevice(list[i]->name(), list[i], ::Group::Support::Tested);
  }
  virtual uint dataSize() const = 0;
  virtual const char *dataStream() const = 0;
};

//----------------------------------------------------------------------------
#if !defined(NO_KDE)
extern TQColor statusColor(Status status);
extern TQPixmap vddGraph(const TQString &xLabel, const TQString &yLabel, const TQValueVector<RangeBox> &boxes);
extern const Package *barPackage(const char *name, const Data &data);
extern TQPixmap pinsGraph(const Package &package);

extern TQString htmlInfo(const Data &data, const TQString &deviceHref, const TQString &documentHtml);
extern TQString htmlPinDiagrams(const Device::Data &data, const TQString &imagePrefix, TQMimeSourceFactory *msf);
extern TQString htmlVoltageFrequencyGraphs(const Device::Data &data, const TQString &imagePrefix, TQMimeSourceFactory *msf);

class MemoryGraphData
{
public:
  Address startAddress, endAddress;
  TQString start, end, label;
  int height;
  bool operator <(const MemoryGraphData &data) const { return ( startAddress < data.startAddress ); }
};
extern TQPixmap memoryGraph(const TQValueList<MemoryGraphData> &ranges);

#endif

} // namespace

#endif
