/***************************************************************************
 *   Copyright (C) 2005 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef LOG_VIEW_H
#define LOG_VIEW_H

#include <tqtextedit.h>
#include "common/global/log.h"

namespace Log
{
enum OutputType { GuiOnly = 0, GuiConsole, Nb_OutputTypes };

class Widget : public TQTextEdit, public View
{
  TQ_OBJECT
  
public:
  Widget(TQWidget *parent = 0, const char *name = 0);
  virtual void appendToLastLine(const TQString &text);
  virtual void clear();
  virtual void sorry(const TQString &message, const TQString &details);
  virtual bool askContinue(const TQString &message);

protected:
  TQPopupMenu *createPopupMenu(const TQPoint &pos);

private slots:
  void toggleVisible(int i);
  void toggleConsoleOutput();
  void saveAs();

private:
  int         _id[DebugLevel::Nb_Types];
  TQPopupMenu *_popup;
  TQString     _text;

  virtual void updateDebugLevel();
  virtual void doLog(LineType type, const TQString &text, Action action = Immediate);
  virtual void doLog(DebugLevel level, const TQString &text, Action action = Immediate);
  void doLog(const TQString &text, const TQString &color, bool bold, Action action = Immediate);
  void logExtra(const TQString &text);
};

} // namespace

#endif
