/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef BOOSTC_COMPILE_H
#define BOOSTC_COMPILE_H

#include "tools/list/compile_process.h"

namespace Boost
{
//----------------------------------------------------------------------------
class Process : public Compile::Process
{
TQ_OBJECT
  
protected:
  virtual TQString deviceName() const { return "PIC" + _data.device; }
  virtual void logStderrLine(const TQString &line);
};

//----------------------------------------------------------------------------
class CompileFile : public Process
{
TQ_OBJECT
  
protected:
  virtual TQStringList genericArguments(const Compile::Config &config) const;
  virtual TQString outputFiles() const;
};

//----------------------------------------------------------------------------
class Link : public Process
{
TQ_OBJECT
  
protected:
  virtual TQString objectExtension() const { return "obj"; }
  virtual TQStringList genericArguments(const Compile::Config &config) const;
  virtual TQString outputFiles() const;
};

} // namespace

#endif
