/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "MarkerModifyDialog.h"
#include <tqlayout.h>

#include <tdelocale.h>
#include "base/Composition.h"
#include "document/RosegardenGUIDoc.h"
#include "gui/widgets/TimeWidget.h"
#include <kdialogbase.h>
#include <tqframe.h>
#include <tqgroupbox.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqspinbox.h>
#include <tqstring.h>
#include <tqvbox.h>
#include <tqwidget.h>
#include "misc/Strings.h"


namespace Rosegarden
{

MarkerModifyDialog::MarkerModifyDialog(TQWidget *parent,
                                       Composition *composition,
                                       int time,
                                       const TQString &name,
                                       const TQString &des):
    KDialogBase(parent, 0, true, i18n("Edit Marker"), Ok | Cancel)
{
    initialise(composition, time, name, des);
}

MarkerModifyDialog::MarkerModifyDialog(TQWidget *parent,
                                       Composition *composition,
                                       Marker *marker) :
    KDialogBase(parent, 0, true, i18n("Edit Marker"), Ok | Cancel)
{
    initialise(composition, marker->getTime(),
               strtoqstr(marker->getName()),
               strtoqstr(marker->getDescription()));
}

void
MarkerModifyDialog::initialise(Composition *composition,
                               int time,
                               const TQString &name,
                               const TQString &des)
{
    m_originalTime = time;

    TQVBox *vbox = makeVBoxMainWidget();

    m_timeEdit = new TimeWidget(i18n("Marker Time"), vbox, composition,
                                time);

    /*!!!
     
        layout->addWidget(new TQLabel(i18n("Absolute Time:"), frame), 0, 0);
        m_timeEdit = new TQSpinBox(frame);
        layout->addWidget(m_timeEdit, 0, 1);
     
        m_timeEdit->setMinValue(INT_MIN);
        m_timeEdit->setMaxValue(INT_MAX);
        m_timeEdit->setLineStep(
                Note(Note::Shortest).getDuration());
        m_timeEdit->setValue(time);
    */
    TQGroupBox *groupBox = new TQGroupBox
                          (1, TQt::Horizontal, i18n("Marker Properties"), vbox);

    TQFrame *frame = new TQFrame(groupBox);

    TQGridLayout *layout = new TQGridLayout(frame, 2, 2, 5, 5);

    layout->addWidget(new TQLabel(i18n("Text:"), frame), 0, 0);
    m_nameEdit = new TQLineEdit(name, frame);
    layout->addWidget(m_nameEdit, 0, 1);

    layout->addWidget(new TQLabel(i18n("Description:"), frame), 1, 0);
    m_desEdit = new TQLineEdit(des, frame);
    layout->addWidget(m_desEdit, 1, 1);

    m_nameEdit->selectAll();
    m_nameEdit->setFocus();
}

}
#include "MarkerModifyDialog.moc"
