/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#ifndef _RG_GUITARCHORDSELECTORDIALOG_H_
#define _RG_GUITARCHORDSELECTORDIALOG_H_

#include "Chord.h"
#include "ChordMap.h"

#include <kdialogbase.h>
#include <tqstring.h>
#include <vector>

class TQListBox;
class TQListBoxItem;
class TQComboBox;
class TQPushButton;

namespace Rosegarden
{

class FingeringBox;

class GuitarChordSelectorDialog : public KDialogBase
{
     TQ_OBJECT
  
    
    enum { COMPLEXITY_BEGINNER, COMPLEXITY_COMMON, COMPLEXITY_ALL };
    
public:
	GuitarChordSelectorDialog(TQWidget *parent=0);

    void init();

    const Guitar::Chord& getChord() const { return m_chord; }

    void setChord(const Guitar::Chord&);

protected slots:
    void slotRootHighlighted(int);
    void slotChordExtHighlighted(int);
    void slotFingeringHighlighted(TQListBoxItem*);
    void slotComplexityChanged(int);
    
    void slotNewFingering();
    void slotDeleteFingering();
    void slotEditFingering();

    virtual void slotOk();

protected:

    void parseChordFiles(const std::vector<TQString>& chordFiles);
    void parseChordFile(const TQString& chordFileName);
    void populateFingerings(const Guitar::ChordMap::chordarray&, const Guitar::Fingering& refFingering=Guitar::Fingering(0));
    void populateExtensions(const TQStringList& extList);

    /// set enabled state of edit/delete buttons
    void setEditionEnabled(bool);
    
    void populate();
    void clear();
    void refresh();
    
    bool saveUserChordMap();
    int evaluateChordComplexity(const TQString& ext);
    
    TQPixmap getFingeringPixmap(const Guitar::Fingering& fingering) const;
         
    /// Find all chord list files on the system
    std::vector<TQString> getAvailableChordFiles();

    Guitar::ChordMap m_chordMap;

    /// current selected chord
    Guitar::Chord m_chord;
    
    // Chord data
    TQListBox* m_rootNotesList;
    TQListBox* m_chordExtList;
    TQListBox* m_fingeringsList;
    FingeringBox* m_fingeringBox;

    TQComboBox*   m_chordComplexityCombo;
    TQPushButton* m_newFingeringButton;
    TQPushButton* m_deleteFingeringButton;
    TQPushButton* m_editFingeringButton;    

    static const unsigned int FINGERING_PIXMAP_HEIGHT = 75;
    static const unsigned int FINGERING_PIXMAP_WIDTH = 75;
    static const unsigned int FINGERING_PIXMAP_H_MARGIN = 5;
    static const unsigned int FINGERING_PIXMAP_W_MARGIN = 5;
    
};

}

#endif /*_RG_GUITARCHORDSELECTORDIALOG_H_*/
