/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_AUDIOPLUGINOSCGUIMANAGER_H_
#define _RG_AUDIOPLUGINOSCGUIMANAGER_H_

#ifdef HAVE_LIBLO

#include <lo/lo.h>
#include "base/MidiProgram.h"
#include <map>
#include "sound/RingBuffer.h"
#include <tqstring.h>



namespace Rosegarden
{

class TimerCallbackAssistant;
class Studio;
class RosegardenGUIApp;
class OSCMessage;
class AudioPluginOSCGUI;


class AudioPluginOSCGUIManager
{
public:
    AudioPluginOSCGUIManager(RosegardenGUIApp *app);
    virtual ~AudioPluginOSCGUIManager();

    void setStudio(Studio *studio) { m_studio = studio; }

    bool hasGUI(InstrumentId id, int position);
    void startGUI(InstrumentId id, int position);
    void showGUI(InstrumentId id, int position);
    void stopGUI(InstrumentId id, int position);
    void stopAllGUIs();

    void postMessage(OSCMessage *message); // I take over ownership of message
    void dispatch();

    void updateProgram(InstrumentId id, int position);
    void updatePort(InstrumentId id, int position, int port);
    void updateConfiguration(InstrumentId id, int position,
                             TQString key);

    TQString getOSCUrl(InstrumentId instrument, int position,
                      TQString identifier);
    TQString getFriendlyName(InstrumentId instrument, int position,
                            TQString identifier);
    bool parseOSCPath(TQString path, InstrumentId &instrument, int &position,
                      TQString &method);

    static void timerCallback(void *data);
    static void guiExitedCallback(void *data);

protected:
    RosegardenGUIApp *m_app;
    Studio *m_studio;

    bool m_haveOSCThread;
    void checkOSCThread();

    lo_server_thread m_serverThread;
    RingBuffer<OSCMessage *> m_oscBuffer;

    typedef std::map<int, AudioPluginOSCGUI *> IntGUIMap;
    typedef std::map<int, IntGUIMap> TargetGUIMap;
    TargetGUIMap m_guis;

    TimerCallbackAssistant *m_dispatchTimer;
};



}

#endif

#endif
