/***************************************************************************
    date                 : Mar 12 2007
    version              : 0.20
    copyright            : (C) 2005-2007 by Holger Danielsson
    email                : holger.danielsson@versanet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef POSTSCRIPTDIALOG_H
#define POSTSCRIPTDIALOG_H

#include <kdialogbase.h>
#include <tqcombobox.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqlineedit.h>
#include <tqstring.h>
#include <kprocess.h>

#include "kilelogwidget.h"
#include "kileoutputwidget.h"

#define PS_A5_EMPTY       0
#define PS_A5_DUPLICATE   1
#define PS_2xA5           2
#define PS_2xA5L          3
#define PS_4xA5           4
#define PS_A4_EMPTY       5
#define PS_A4_DUPLICATE   6
#define PS_2xA4           7
#define PS_2xA4L          8
#define PS_EVEN           9
#define PS_ODD            10
#define PS_EVEN_REV       11
#define PS_ODD_REV        12
#define PS_REVERSE        13
#define PS_COPY_SORTED    14
#define PS_COPY_UNSORTED  15
#define PS_PSTOPS_FREE    16
#define PS_PSSELECT_FREE  17

class KShellProcess;

namespace KileDialog
{

class PostscriptDialog : public KDialogBase   
{
	TQ_OBJECT
  

public:
	PostscriptDialog(TQWidget *parent, 
	              const TQString &texfilename,const TQString &startdir,
                 const TQString &latexextensions,
	              KileWidget::LogMsg *log, KileWidget::Output *output);
	~PostscriptDialog();

signals:
	void output(const TQString &);

private slots:
	void chooseInfile();
	void chooseOutfile();
	void comboboxChanged(int index);
	void slotUser1();
	void slotProcessOutput(TDEProcess*,char* buf,int len);
	void slotProcessExited (TDEProcess *proc);
	
private:
	bool checkParameter();
	TQString buildTempfile();
	TQString duplicateParameter(const TQString &param);
	void showError(const TQString &text);
	void execute();
	
	TQLineEdit *m_edInfile, *m_edOutfile, *m_edParameter;
	TQComboBox *m_cbTask;
	TQCheckBox *m_cbView;
	TQSpinBox *m_spCopies;
	TQLabel *m_lbParameter;
	
	TQString m_startdir;
	KileWidget::LogMsg *m_log;
	KileWidget::Output *m_output;
	
	TQString m_tempfile;
	TQString m_program;
	TQString m_param;

	KShellProcess* m_proc;

};

}


#endif
