/*
 * valuemanager.cpp - part of abakus
 * Copyright (C) 2004, 2005 Michael Pyne <michael.pyne@kdemail.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <kdebug.h>
#include <tdelocale.h>

#include <tqregexp.h>

#include "numerictypes.h"
#include "valuemanager.h"

ValueManager *ValueManager::m_manager = 0;

ValueManager *ValueManager::instance()
{
    if(!m_manager)
        m_manager = new ValueManager;

    return m_manager;
}

ValueManager::ValueManager(TQObject *parent, const char *name) :
    TQObject(parent, name)
{
    m_values.insert("pi", Abakus::number_t::PI);
    m_values.insert("e", Abakus::number_t::E);
}

Abakus::number_t ValueManager::value(const TQString &name) const
{
    return m_values[name];
}

bool ValueManager::isValueSet(const TQString &name) const
{
    return m_values.contains(name);
}

bool ValueManager::isValueReadOnly(const TQString &name) const
{
    TQRegExp readOnlyValues("^(ans|pi|e|stackCount)$");

    return name.find(readOnlyValues) != -1;
}

void ValueManager::setValue(const TQString &name, const Abakus::number_t value)
{
    if(m_values.contains(name) && this->value(name) != value)
        emit signalValueChanged(name, value);
    else if(!m_values.contains(name))
        emit signalValueAdded(name, value);

    m_values.replace(name, value);
}

void ValueManager::removeValue(const TQString &name)
{
    if(m_values.contains(name))
        emit signalValueRemoved(name);

    m_values.remove(name);
}

void ValueManager::slotRemoveUserVariables()
{
    TQStringList vars = valueNames();

    for(TQStringList::ConstIterator var = vars.constBegin(); var != vars.constEnd(); ++var)
        if(!isValueReadOnly(*var))
            removeValue(*var);
}

TQStringList ValueManager::valueNames() const
{
    return m_values.keys();
}

TQString ValueManager::description(const TQString &valueName)
{
    if(valueName == "e")
        return i18n("Natural exponential base - 2.7182818");
    if(valueName == "pi")
        return i18n("pi (π) - 3.1415926");

    return TQString();
}

#include "valuemanager.moc"
