/***************************************************************************
                          commands_file  -  description
                             -------------------
    begin                : Wed Nov 26 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : a_charytoniuk@user.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef COMMANDS_FILE_H
#define COMMANDS_FILE_H

#include "kxecommand.h"
#include <tdelocale.h>

/** @file
	This file contains all commands taken from menu File which
	can effect our edited document. These commans allows to have
	undo/redo functionality.
*/

/**
Command for setting version and encoding to XML file.

@author The KXMLEditor Team
*/

class KXEDocument;
class TQString;

class KXEVersionEncodingCommand : public KXECommand
{
	public:
		KXEVersionEncodingCommand(KXEDocument* pDocument, const TQString& oldData, const TQString &newData);
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Changing version and encoding"); }
		~KXEVersionEncodingCommand();
	protected:
		TQString m_strOldData;
		TQString m_strNewData;
};

class KXEStylesheetAttachCommand : public KXECommand
{
	public:
		KXEStylesheetAttachCommand(KXEDocument* pDocument,const TQString& prevStylesheet,const TQString& newStylesheet);
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Attaching stylesheet ")+m_strNewStylesheet; }
		~KXEStylesheetAttachCommand();
	protected:
		TQString m_strPrevStylesheet;
		TQString m_strNewStylesheet;
};

class KXEStylesheetDetachCommand : public KXECommand
{
	public:
		KXEStylesheetDetachCommand(KXEDocument* pDocument,const TQString& prevStylesheet);
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Detaching stylesheet ")+m_strPrevStylesheet; }
		~KXEStylesheetDetachCommand();
	protected:
		TQString m_strPrevStylesheet;
};

class KXESchemaAttachCommand : public KXECommand
{
	public:
		KXESchemaAttachCommand(KXEDocument *pDocument,const TQString& newSchema);
		KXESchemaAttachCommand(KXEDocument *pDocument,const TQString& newSchema, const TQString& prevSchema);
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Attaching schema ")+m_strNewSchema; }
		~KXESchemaAttachCommand();
	protected:
		TQString m_strNewSchema;
		TQString m_strPrevSchema;
};

class KXESchemaDetachCommand : public KXECommand
{
	public:
		KXESchemaDetachCommand(KXEDocument* pDocument, const TQString& schema);
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Detaching schema ")+m_schema; }
		~KXESchemaDetachCommand();
	protected:
		TQString m_schema;
};

#endif
