/***************************************************************************
                           kxenewfilesettings.cpp
                           ----------------------
    begin                : Tue Dec 02 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxenewfilesettings.h"
#include "kxenewfilesettingspage.h"

#include <tdelocale.h>
#include <tdeconfig.h>
#include <kdebug.h>

#include <tqframe.h>
#include <tqlineedit.h>
#include <tqcombobox.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>

#define CONF_ENTRY_NAME_DFLT_VERSION "Default version"
#define DFLT_VALUE_DFLT_VERSION "1.0"

#define CONF_ENTRY_NAME_DFLT_ENCODING "Default encoding"
#define DFLT_VALUE_DFLT_ENCODING "UTF-8"

#define CONF_ENTRY_NAME_DFLT_NEWFILE_CREAT_BEHAVIOUR "Default behaviour"
#define DFLT_VALUE_NEWFILE_CREAT_BEHAVIOUR UseDefaults


KXENewFileSettings::KXENewFileSettings( TQObject * pParent, const char * pszName )
 : KXESettings( "New File Settings", pParent, pszName ),
   m_strDfltVersion( DFLT_VALUE_DFLT_VERSION ),
   m_strDfltEncoding( DFLT_VALUE_DFLT_ENCODING ),
   m_enmNewFileCreaBehav( DFLT_VALUE_NEWFILE_CREAT_BEHAVIOUR ),
   m_pDialogPage(0)
{
}


void KXENewFileSettings::write( TDEConfig * pConfig ) const
{
	pConfig->writeEntry( CONF_ENTRY_NAME_DFLT_VERSION, m_strDfltVersion );
	pConfig->writeEntry( CONF_ENTRY_NAME_DFLT_ENCODING, m_strDfltEncoding );
	pConfig->writeEntry( CONF_ENTRY_NAME_DFLT_NEWFILE_CREAT_BEHAVIOUR, m_enmNewFileCreaBehav );
}


void KXENewFileSettings::read( const TDEConfig * pConfig )
{
	m_strDfltVersion = pConfig->readEntry( CONF_ENTRY_NAME_DFLT_VERSION, DFLT_VALUE_DFLT_VERSION );
	m_strDfltEncoding = pConfig->readEntry( CONF_ENTRY_NAME_DFLT_ENCODING, DFLT_VALUE_DFLT_ENCODING );
	m_enmNewFileCreaBehav = static_cast<NewFileCreationBehaviour> ( pConfig->readNumEntry( CONF_ENTRY_NAME_DFLT_NEWFILE_CREAT_BEHAVIOUR, DFLT_VALUE_NEWFILE_CREAT_BEHAVIOUR ) );
}


TQString KXENewFileSettings::dialogPageName() const
{
	return i18n( "New Files" );
}

TQString KXENewFileSettings::dialogPageHeader() const
{
	return i18n( "New File Settings" );
}

TQString KXENewFileSettings::dialogPageIcon() const
{
	return "document-new";
}


TQWidget * KXENewFileSettings::dialogPage( TQFrame * pParent )
{

	if ( ! m_pDialogPage )
	{
		// create the page if necessary
		m_pDialogPage = new KXENewFileSettingsPage( pParent, "new files config.dialog page" );

		// and fill its widgets with the corresponding values
		m_pDialogPage->m_pDfltEncoding->insertStringList( encodings() );
		updatePage();

		connect( m_pDialogPage->m_pDfltVersion, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pDfltEncoding, TQ_SIGNAL(activated(int)), this, TQ_SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pNewFileCreatBehav1, TQ_SIGNAL(toggled(bool)), this, TQ_SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pNewFileCreatBehav2, TQ_SIGNAL(toggled(bool)), this, TQ_SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pNewFileCreatBehav3, TQ_SIGNAL(toggled(bool)), this, TQ_SIGNAL(sigDialogPageChanged()) );
	}

	return m_pDialogPage;
}

void KXENewFileSettings::setFromPage()
{
	if ( m_pDialogPage )
	{
		m_strDfltVersion = m_pDialogPage->m_pDfltVersion->text();
		m_strDfltEncoding = m_pDialogPage->m_pDfltEncoding->currentText();

		if ( m_pDialogPage->m_pNewFileCreatBehav1->isChecked() )
			m_enmNewFileCreaBehav = CreateEmptyFile;
		else if ( m_pDialogPage->m_pNewFileCreatBehav2->isChecked() )
			m_enmNewFileCreaBehav = CreateWithAssistance;
		else if ( m_pDialogPage->m_pNewFileCreatBehav3->isChecked() )
			m_enmNewFileCreaBehav = UseDefaults;
	}
}

void KXENewFileSettings::updatePage() const
{
	if ( m_pDialogPage )
	{
		m_pDialogPage->m_pDfltVersion->setText( m_strDfltVersion );
		m_pDialogPage->m_pDfltEncoding->setCurrentText( m_strDfltEncoding );

		switch ( m_enmNewFileCreaBehav )
		{
			case CreateEmptyFile:
				m_pDialogPage->m_pNewFileCreatBehav->setButton( m_pDialogPage->m_pNewFileCreatBehav->id( m_pDialogPage->m_pNewFileCreatBehav1 ) );
				break;
			case CreateWithAssistance:
				m_pDialogPage->m_pNewFileCreatBehav->setButton( m_pDialogPage->m_pNewFileCreatBehav->id( m_pDialogPage->m_pNewFileCreatBehav2 ) );
				break;
			case UseDefaults:
				m_pDialogPage->m_pNewFileCreatBehav->setButton( m_pDialogPage->m_pNewFileCreatBehav->id( m_pDialogPage->m_pNewFileCreatBehav3 ) );
				break;
			default:
				kdError() << "KXENewFileSettings::updatePage: unknown creation behavior" << endl;
		}
	}
}

TQStringList KXENewFileSettings::encodings()
{
	static TQStringList lstEncs;
	if ( lstEncs.empty() )
	{
		lstEncs.append("UTF-8");
		lstEncs.append("ISO-8859-1");
		lstEncs.append("ISO-8859-2");
		lstEncs.append("ISO-8859-3");
		lstEncs.append("ISO-8859-4");
		lstEncs.append("ISO-8859-5");
		lstEncs.append("ISO-8859-6");
		lstEncs.append("ISO-8859-7");
		lstEncs.append("ISO-8859-8");
		lstEncs.append("ISO-8859-9");
	}
	return lstEncs;
}


/////////////////////////////////////////////////
// function(s) to set this settings group data //
/////////////////////////////////////////////////

void KXENewFileSettings::setNewFileCreaBehav( NewFileCreationBehaviour enmNewFileCreaBehav, TDEConfig * pConfig )
{
	// if the data really has been changed
	if ( m_enmNewFileCreaBehav != enmNewFileCreaBehav )
	{
		// set this object's data to the new one given
		m_enmNewFileCreaBehav = enmNewFileCreaBehav;

		// update the corresponding widget in the config.dialog page, if necessary
		if ( m_pDialogPage )
		{
			blockSignals( true );

			switch ( enmNewFileCreaBehav )
			{
				case CreateEmptyFile:
					m_pDialogPage->m_pNewFileCreatBehav->setButton( m_pDialogPage->m_pNewFileCreatBehav->id( m_pDialogPage->m_pNewFileCreatBehav1 ) );
					break;
				case CreateWithAssistance:
					m_pDialogPage->m_pNewFileCreatBehav->setButton( m_pDialogPage->m_pNewFileCreatBehav->id( m_pDialogPage->m_pNewFileCreatBehav2 ) );
					break;
				case UseDefaults:
					m_pDialogPage->m_pNewFileCreatBehav->setButton( m_pDialogPage->m_pNewFileCreatBehav->id( m_pDialogPage->m_pNewFileCreatBehav3 ) );
					break;
				default:
					kdError() << "KXENewFileSettings::dialogPage: unknown creation behavior" << endl;
			}

			blockSignals( false );
		}

		// store the new data (only the given one) to the given config file
		setConfigGroup( pConfig );
		pConfig->writeEntry( CONF_ENTRY_NAME_DFLT_NEWFILE_CREAT_BEHAVIOUR, m_enmNewFileCreaBehav );

		// and inform everyone about the changing of our data
		emit sigChanged();
	}
}
