/***************************************************************************
                          kxesyntaxhighlighter.h  -  XML Syntax highlighter
                             -------------------
    begin                : Ne pro 14 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : lvanek.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXESYNTAXHIGHLIGHTER_H
#define KXESYNTAXHIGHLIGHTER_H

#include <tqsyntaxhighlighter.h>

class TQTextEdit;

/**XML Syntax highlighter
  *@author Lumir Vanek
  */

class KXESyntaxHighlighter : public TQSyntaxHighlighter
{
public: 
	KXESyntaxHighlighter(TQTextEdit *);
	~KXESyntaxHighlighter();

  int highlightParagraph(const TQString &text, int endStateOfLastPara);

  void setColorDefaultText(const TQColor color) { m_clrDefaultText = color; }
  void setColorElementNames(const TQColor color) { m_clrElementName = color; }
  void setColorAttributeNames(const TQColor color) { m_clrAttributeName = color; }
  void setColorAttributeValues(const TQColor color) { m_clrAttributeValue = color; }
  void setColorXmlSyntaxChars(const TQColor color) { m_clrXmlSyntaxChar = color; }
  void setColorComments(const TQColor color) { m_clrComment = color; }
  void setColorSyntaxError(const TQColor color) { m_clrSyntaxError = color; }

  const TQColor colorDefaultText() const { return m_clrDefaultText; }
  const TQColor colorElementNames() const { return m_clrElementName; }
  const TQColor colorAttributeNames() const { return m_clrAttributeName; }
  const TQColor colorAttributeValues() const { return m_clrAttributeValue; }
  const TQColor colorXmlSyntaxChars() const { return m_clrXmlSyntaxChar; }
  const TQColor colorComments() const { return m_clrComment; }
  const TQColor colorSyntaxError() const { return m_clrSyntaxError; }
  
protected:
  int processDefaultText(int, const TQString&);
  
protected:

  TQColor m_clrDefaultText;
  TQColor m_clrElementName;
  TQColor m_clrAttributeName;
  TQColor m_clrAttributeValue;
  TQColor m_clrXmlSyntaxChar; // < > = "
  TQColor m_clrComment;
  TQColor m_clrSyntaxError;

  // states for parsing XML
  enum ParserState
	{
    parsingNone = 0,
    expectElementNameOrSlash,
    expectElementName,
    expectAtttributeOrEndOfElement,
		expectEqual,
    expectAttributeValue
	};

  ParserState m_eParserState;
};

#endif
