/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef BTINSTALLMGR_H
#define BTINSTALLMGR_H


//BibleTIme includes
#include "backend/cswordbackend.h"
#include "config.h"

//sword includes
#include <installmgr.h>
#include <ftplibftpt.h>

//TQt includes
#include <tqobject.h>
#include <tqptrlist.h>
#include <tqstring.h>
#include <tqstringlist.h>

#ifdef SWORD_MULTIVERSE
#define SWORD_INTERNET_WARNING 1
#endif

namespace BookshelfManager {

	typedef TQPtrList<sword::InstallSource> InstallSourceList;

	/**Our own reimplementation to provide status bar updates.
	  *@author The BibleTime team
	  */
class BTInstallMgr : public TQObject, public sword::InstallMgr, public sword::StatusReporter {
		TQ_OBJECT
  
public:
		class Tool {
public:
			class LocalConfig {
public:
				static const TQString swordConfigFilename();
				static TQStringList targetList();
				static void setTargetList( const TQStringList& );
private:
				LocalConfig() {}
				;
			};

			class RemoteConfig {
public:
				static void initConfig();
				static const TQString configPath();
				static const TQString configFilename();

				static void resetRemoteSources();
				static void resetLocalSources();

				static TQStringList sourceList( sword::InstallMgr* );
				static sword::InstallSource source( sword::InstallMgr*, const TQString& name );
				static const bool isRemoteSource( sword::InstallSource* is );
				static void addSource( sword::InstallSource* );
				static void removeSource( sword::InstallMgr*, sword::InstallSource* );


private:
				RemoteConfig() {}
				;
			};

			static CSwordBackend* backend( sword::InstallSource* const );

private:
			Tool() {}
			;
		};

		BTInstallMgr();
		virtual ~BTInstallMgr();

#ifdef SWORD_INTERNET_WARNING
public:
		/** Re-implemented from sword::InstallMgr. */
		virtual bool isUserDisclaimerConfirmed() const;
#endif

protected:
		/* Reimplementations of method in StatusReporter */
		virtual void statusUpdate(double dltotal, double dlnow);
		virtual void preStatus(long totalBytes, long completedBytes, const char *message);

//		virtual FTPTransport *createFTPTransport(const char *host, StatusReporter *statusReporter);

		long m_totalBytes;
		long m_completedBytes;

signals: // Signals
		void completed( const int, const int );
		/**
		* Emitted when a new file gets downloaded.
		*/
		void downloadStarted( const TQString& );
	};

}

#endif
