;/***************************************************************************\
;* level0_h.s                                                                *
;* Version 1.20                                                              *
;* Level 0 Debug Monitor Code Header                                         *
;* Copyright (C) 1991 Advanced RISC Machines Limited. All rights reserved.   *
;* Written by Dave Jaggar.                                                   *
;* Project started on 2nd January 1992.                                      *
;* Last change was 11th October 1993.                                        *
;\***************************************************************************/

 [ TARGET = "PIE"
 [ {CONFIG} = 32
AreaSize        EQU     &40000000
 |
AreaSize        EQU     &01000000
 ]
 ]
 [ TARGET = "PID"
AreaSize        EQU     &01000000
 ]

 [ TARGET = "a3000"
RAMBase                 EQU     0
ExpBase                 EQU     0
IOBase                  EQU     &03010000
ROMBase                 EQU     &00100000
 |
RAMBase                 EQU     AreaSize * 0
ExpBase                 EQU     AreaSize * 1
IOBase                  EQU     AreaSize * 2
ROMBase                 EQU     AreaSize * 3
SectionsPerArea         EQU     AreaSize / &100000
 ]

;/***************************************************************************\
;*                               ARM Constants                               *
;\***************************************************************************/

ResetV                  EQU     0
UndefInstrV             EQU     4
SWIV                    EQU     8
PrefAbortV              EQU     &c
DataAbortV              EQU     &10
AddrExceptV             EQU     &14
IRQV                    EQU     &18
FIQV                    EQU     &1c
ErrorV                  EQU     &20
LastV                   EQU     &24

User26Mode              EQU     &0
FIQ26Mode               EQU     &1
IRQ26Mode               EQU     &2
SVC26Mode               EQU     &3

User32Mode              EQU     &10
FIQ32Mode               EQU     &11
IRQ32Mode               EQU     &12
SVC32Mode               EQU     &13
Abort32Mode             EQU     &17
Undef32Mode             EQU     &1b
Mask32Mode              EQU     &1f

PSR_32Bit               EQU     &10
 [ {CONFIG} = 26
CPSRMask                EQU     &fc000003
CTLMask                 EQU     &0c000003
ModeMask                EQU     &00000003                        
SubModeMask             EQU     &00000003                        
NoInt                   EQU     &0c000000
IFConfig                EQU     &0c000000
 |
ModeMask                EQU     &0000001f 
SubModeMask             EQU     &0000000f 
NoInt                   EQU     &000000c0
IFConfig                EQU     &000000d0
 ]
CCMask                  EQU     &f0000000

;/***************************************************************************\
;*                              Memory Layout                            *
;\***************************************************************************/

FIQStackBase            EQU     &400
IRQStackBase            EQU     &500
UndefStackBase          EQU     &700
AbortStackBase          EQU     &800
SVCStackBase            EQU     &A00

WorkBase                EQU     &A00
SavedRegs               EQU     WorkBase            ; Address must fit in a DP constant !
SoftVectors             EQU     WorkBase + &40      ; Address must fit in a Load constant !
RDPHandlerV             EQU     SoftVectors + LastV
        ASSERT  RDPHandlerV = WorkBase + &64
NextIntHandler          EQU     WorkBase + &68
ResetVectorCopy         EQU     WorkBase + &6c
EndianWord              EQU     WorkBase + &70
TimerVal                EQU     WorkBase + &74
RAMSize                 EQU     WorkBase + &78
MMUType                 EQU     WorkBase + &7c
 [ TARGET = "PIE"
Level0RAMLimit          EQU     WorkBase + &80
 ]
 [ TARGET = "PID"
IRQVectors              EQU     WorkBase + &80
FIQVectors              EQU     WorkBase + &A0
SavedIRQMask            EQU     WorkBase + &C0  ; IRQ mask is Write only (pid)
SavedFIQMask            EQU     WorkBase + &C4  ; FIQ mask is Write only (pid)
Level0RAMLimit          EQU     WorkBase + &D0
 ]

ROMVectors              EQU     &100

;/***************************************************************************\
;*                              MMU constants                                *
;\***************************************************************************/

MMUCP                   CP      15

MMUIDReg                CN      0
MMUControlReg           CN      1
MMUPageTableBaseReg     CN      2
MMUDomainAccessReg      CN      3
MMUFlushTLBReg          CN      5
MMUPurgeTLBReg          CN      6
MMUFlushIDCReg          CN      7

PageTable1Size          EQU     4 * 4 * 1024 ; one per megabyte

MMU                     EQU     1 ; 0 is off, 1 is on
AlignFault              EQU     0 ; 0 is off, 2 is on
Cache                   EQU     4 ; 0 is off, 4 is on
WriteBuffer             EQU     8 ; 0 is off, 8 is on
Config26Bit             EQU     0 ; mmu, idc, wb off, 26 bit prog/data, little endian
Config32Bit             EQU     &10 + &20 ; mmu, idc, wb off, 32 bit prog/data, little endian
EnableMMU26             EQU     Config26Bit + MMU + AlignFault + Cache + WriteBuffer
EnableMMU32             EQU     Config32Bit + MMU + AlignFault + Cache + WriteBuffer

                        END
