; An example level 1 Page Table for ARM600 generated by
; armasm using repetitive assembly.

; Level 1 page table entries (1MB per entry)
; &0-&3    Section, PA=VA, SVC only, U_BIT, C_BIT, B_BIT, Domain 0
; &4-&1F   No Access
; &20      Section, PA=&FFF00000 + offset, SVC only, Not U, C, or B, Domain 1
; &21-&3F  No Access
; &40-&47  Large Pages, Page Table Offsets start at &300000 (PA), each L2 Page
;          Table being 1K long, U_BIT, Domain 15
;         (Access permissions and B_BIT/C_BIT are in L2 Page Table)
; &48-&FFF No Access

; Access Permissions - not shifted into position.
NO_ACCESS  * 0  ; Depending on the setup, 0 represents one of 
SVC_R      * 0  ; these two access permissions (see ARM600 datasheet)
SVC_RW     * 1
NO_USR_W   * 2
ALL_ACCESS * 3

; U, C and B bits in their correct positions (see ARM600 datasheet)
U_BIT * 16
C_BIT  * 8
B_BIT * 4

; Entry type
SECTION    * 2
PAGE       * 1
INVALID    * 0

  MACRO
  L1Entry $type, $addr, $dom, $ucb, $acc
  IF ($type=SECTION)
    DCD ((($addr):AND:&FFF00000):OR:(($acc):SHL:10) \
          :OR:(($dom):SHL:5):OR:($ucb):OR:($type))
    MEXIT
  ENDIF
  IF ($type=PAGE)
    DCD ((($addr):AND:&FFFFFC00):OR:(($dom):SHL:5) \
          :OR:(($ucb):AND:U_BIT):OR:$type)
  ELSE
    DCD 0 ; Invalid Level 1 Page Table Entry
  ENDIF
  MEND

  AREA Pagetab,DATA

  GBLA    counter

counter SETA 0
  WHILE   counter <= 3 ; Entries &0 - &3
  L1Entry SECTION, (counter:SHL:20), 0, U_BIT+C_BIT+B_BIT, SVC_RW
counter SETA counter+1
  WEND

  WHILE   counter <= &1F ; Entries &4 - &1F
  L1Entry INVALID, 0, 0, 0, 0
counter SETA counter+1
  WEND

  ; Entry &20
  L1Entry SECTION, &FFF00000, 1, 0, SVC_RW

counter SETA &21
  WHILE   counter <= &3F ; Entries &21 - &3F
  L1Entry INVALID, 0, 0, 0, 0
counter SETA counter+1
  WEND

  WHILE   counter <= &47 ; Entries &40 - &47
  L1Entry PAGE, &300000+((counter-&40)*1024), 15, U_BIT, 0
counter SETA counter+1
  WEND

  WHILE   counter <= &FFF ; Entries &48 - &FFF
  L1Entry INVALID, 0, 0, 0, 0
counter SETA counter+1
  WEND

  END
