/* timout info */
#define DEL 5			/* Delay time */
#define TIMEOUT_COUNT 15000     /* Loop iterations for timeout */

/* adm defaults */
#define adm_type_default        0xa2    /* default adm type is 56002 */
#define adm_active_default      0x01    /* default adm is zero.      */  
#define set_adm_type 0
#define set_adm_active 1
#define set_active_type 2

/* dsp generic types */
#define dsp16bit        0x10
#define dsp24bit        0x20
#define dsp32bit        0x40


#define MDSP_MINPHYS_SIZE	0xFFFF

/*
 * Data structure definitions:
 */
struct mdsp_regs                              /* registers */
{

    volatile u_char     adm_control;        /* control register     */

#define ADM_ZERO        0x00                    /* These bits are the   */
#define ADM_BRK         0x01                    /* outputs to the ADM   */
#define HOST_REQ        0x02                    /* from the device drvr */
#define HOST_ACK        0x04
#define ADM_ALL         0x08
#define ADM_SEL0        0x10
#define ADM_SEL1        0x20
#define ADM_SEL2        0x40
#define ADM_RESET       0x80

#define ADM_INT         0x01                    /* These bits are the   */
#define ADM_REQ         0x02                    /* inputs from the ADM  */
#define ADM_ACK         0x04                    /* to the device driver */
#define HOST_BRK        0x08

    volatile u_char      adm_data;          /* data io port         */
    volatile u_char      adm_group;         /* group/brace sel reg  */

#define BRACE_SEL       0x20
#define INT_ACK         0x40
#define ADM_GROUP       0x80

    volatile u_char      adm_interrupt;     /* interrupt control    */

#define INT0            0x01
#define INT1            0x02
#define INT2            0x04
#define INT_EN          0x08

    volatile u_char      dum1;            /* dummy for padding to match PROM */
    volatile u_char      dum2;
    volatile u_char      dum3;
    volatile u_char      dum4;
};

struct mdsp_state
{
    dev_info_t		*dip;
    ddi_iblock_cookie_t	iblock_cookie;      /* for mutexes */
    struct mdsp_regs *regsp;                /* Device control regs. */
    int control;
    u_char          adm_type[32];           /* type flags for adms  */
    u_char          adm_active;             /* which adms are active */
    u_char          adm_active_type;        /* current active type  */
} ;



struct fakeit 
{
  char fake[IOCPARM_MASK]; /* note: change to IOCPARM_MASK on Solaris */
} ;


/* mdsp_ioctl commands */
#define MDSPRESET       _IOW('m',1,int)        /* set adm reset line */
#define MDSPBREAK       _IOW('m',2,int)        /* force adm break */
#define MDSPCOMMAND     _IOW('m',3,struct fakeit) /* send read command */
#define MDSPSELECT      _IOW('m',4,int)        /* select an adm for a group */
#define MDSPDESELECT    _IOW('m',5,int)        /* deselect an adm group */
#define MDSPCLEAR       _IOW('m',6,int)        /* clear adm reset line */
#define MDSPWBYTE       _IOW('m',7,int)        /* write byte to data addr */
#define MDSPRBYTE       _IOWR('m',8,int)       /* read byte from data addr */
#define MDSPDEVICE      _IOW('m',9,int)        /* set mdspsoftc.ctrl1 ADM */
#define MDSPIOW         _IOW('m',10,int)       /* write to an address */
#define MDSPIOR         _IOWR('m',11,int)      /* read from an address */
 
#define MDSPSETADM      _IOW('m',19,int)       /* set the adm type */
#define MDSPVERSION     _IOWR('m',20,char[120]) /* return the driver version */
#define MDSPDUMP        _IOW('m',21,int)       /* Status for Debugging */
