/* $Id: rgcom.h,v 1.7 1997/02/17 20:19:13 jay Exp $ */
/* Copyright (C) 1995, by Motorola, Inc. */

#ifndef	__rgcom_h__
#define __rgcom_h__

/*
 * Compiler's options
 */

/*
   #define __USE_FIXED_PROTOTYPES__
 */


#define		MODE_READ	"r"
#define		MODE_WRITE	"w"
#define		MODE_APPEND	"r+"
#define		MODE_READ_BIN	"rb"
#define		MODE_WRITE_BIN	"wb"
#define		MODE_APPEND_BIN	"r+b"

#if MSDOS
#define         PATH_CHAR       '\\'
#define         NL      "\r\n"
#else /* MSDOS */
#define         PATH_CHAR       '/'
#define         NL      "\n"
#endif /* MSDOS */

#define         TAB_WIDTH       8
#define		TAB		'\t'
#define         BLANK           ' '
#define		NEWLINE		'\n'

#define		MAX_INPUTLINE_LEN	400
#define		INPUTLINE_LIMIT		256

/*
 * File name and access defines and types
 */
#define MAX_FILE_NAME_LEN         128
#define MAX_FULL_PATH_LEN         256
typedef char FILE_NAME[MAX_FILE_NAME_LEN + 1];
typedef char FILE_PATH[MAX_FULL_PATH_LEN + 1];

/*
 * Common defines
 */
#define NULL_CHAR              '\000'
#define BLANK_CHAR             ' '
#define SLASH_CHAR             '/'
#define BACK_SLASH_CHAR        '\\'
#define DOT_CHAR               '.'
#define EQ_CHAR                '='

#define NULL_STRING            ""
#define DOT_STRING             "."
#define STRING_FORMAT          "%s"
#define ULONG_FORMAT           "%lu"
#define LONG_FORMAT            "%ld"
#define UINT_FORMAT            "%u"
#define INT_FORMAT             "%d"
#define CHAR_FORMAT            "%c"
#define HEX_FORMAT             "%x"
#define LHEX_FORMAT            "%lx"

#define MEM_BLOCK_SIZE 20000
#define DEFAULT_FONT_SIZE 10
#define SYMBOL_LENGTH 22
#define RNL 6			/* maximal addition (for the length of "...(M)") */
#define RG_NEWF "{new}"
#define RG_LASTF "{end}"

#define         RC_DEF_LIST     \
RDEF(RC_OK,             "OK")\
RDEF(RC_FAILED,         "FAILURE")\
RDEF(RC_WARNING,        "WARNING")\
RDEF(RC_E_ABORT,        "*** MAJOR PROFILING ERROR - SIMULATOR ABORTED ***")\
RDEF(RC_E_MEM,          "Insufficient memory")\
RDEF(RC_E_CLD,          "No object file loaded")\
RDEF(RC_E_COFF,         "Failed to handle COFF file")\
RDEF(RC_E_NULLFILENAME, "Null file name")\
RDEF(RC_E_FILE,         "File %s does not exist")\
RDEF(RC_E_DIR,          "Directory %s does not exist")\
RDEF(RC_E_PERMISSIONS,  "Permissions on %s")\
RDEF(RC_E_NAME_LENGTH,  "Name %s exceeds length limit (%d)")\
RDEF(RC_E_RANGE,        "Value %d out of range for %s")\
RDEF(RC_E_OPEN,         "Failed to open file %s")\
RDEF(RC_E_OPEN_SRC,     "Failed to open source file %s")\
RDEF(RC_E_FILE_TIME,    "Source file %s more recent than executable")\
RDEF(RC_E_CLOSE,        "Failed to close file %s")\
RDEF(RC_E_DELETE,       "Failed to delete file %s")\
RDEF(RC_E_READ,         "Failed to read from file %s")\
RDEF(RC_E_FILE_NAME,    "File %s, line %d: Invalid or missing file name")\
RDEF(RC_E_LINE_OPEN,    "File %s, line %d: Cannot open file %s")\
RDEF(RC_E_LONGLINE ,    "File %s, line %d: Line too long")\
RDEF(RC_E_PS_STACK,     "")\
RDEF(RC_E_ILL_DIRECTIVE,"File %s, line %d: Directive %s not allowed here")\
RDEF(RC_E_INV_DIRECTIVE,"File %s, line %d: Invalid directive")\
RDEF(RC_E_LOG,          "Profiler file not generated")

#define RC ReturnCode
typedef enum return_code
{
#define         RDEF(CODE,STR)  CODE,
    RC_DEF_LIST
#undef         RDEF
    RC_LAST			/* Place holder */
}
RC;

char *siml_ut_get_oper_name (int oper);

/************************************************************
 *  TREE function's enumerations (see functions definitions)
 ************************************************************/

typedef enum
{
    n_L, n_E, n_R, n_Z
}
COMPARE_answ;

typedef enum
{
    in_LR, in_RL, pre_LR, pre_RL, post_LR, post_RL
}
VISIT_order;

typedef enum
{
    v_NON, v_PRE, v_POST, v_pre_POST
}
VISIT_poles;

typedef enum
{
    dup_NO, dup_YES
}
DUP_mode;

typedef enum
{
    del_NO, del_YES, del_NODE
}
REMOVE_mode;

typedef enum
{
    err_CRASH, err_RECOVER, err_WARN, err_MINOR
}
ERR_mode;

typedef enum
{
    get_I_RECENT, get_I_DATA, get_I_STATIC
}
GET_inst_mode;

typedef enum
{
    REP_ASCII,
    REP_JOINT,
    REP_POSTSCRIPT
}
REP_MODE;

/* 
 * The following chars (strings) has a special meaning when appearing as
 *  the first character of a message to be printed with siml_rgprintf : 
 *
 *  ASCII    - message should only be printed in ascii report 
 *  PS       - message should only be printed in ps report 
 *  META_PS  - message should only be printed directly to
 *                   the ps report (used for postscript commands)
 *  META     - the following chars contains a special action description
 *             (for example - "META P_2 META" will print two underscore)
 */
#define ASCII_char     '\x80'
#define PS_char        '\x81'
#define META_PS_char   '\x82'
#define META_char      '\x83'
#define ASCII    "\x80"
#define PS       "\x81"
#define META_PS  "\x82"
#define META     "\x83"

#define ALL_FONTS \
FONT_DESC(Helvetica) \
FONT_DESC(Helvetica_Oblique) \
FONT_DESC(Helvetica_Bold) \
FONT_DESC(Courier) \
FONT_DESC(Courier_Bold) \
FONT_DESC(Courier_Oblique) \
FONT_DESC(Times_Italic)

typedef enum
{
#define FONT_DESC(X) X,
    ALL_FONTS
#undef FONT_DESC
    last_font
}
FONT;

typedef enum
{
    FONT_PUSH,
    FONT_PUSH_SIZE,
    FONT_PUSH_SHAPE,
    FONT_SET,
    FONT_SET_SIZE,
    FONT_SET_SHAPE,
    FONT_POP,
    FONT_TOP
}
FONT_OP;

typedef enum
{
    T_void,

    T_PROGRAM,
    T_TREE,
    T_NODE,
    T_INSTRUCTION_NODE,
    T_INST_INFO,
    T_SYMBOL,
    T_ROUTINE,
    T_CALL,
    T_ENTER,
    T_CHILD,
    T_PARENT
}
TYPES;

#define TREE_COMPARISON_FUNCIONS \
COMP(data_by_addr), \
COMP(inst_by_addr), \
COMP(inst_by_src), \
COMP(inst_by_txt), \
COMP(symb_by_name), \
COMP(symb_by_addr), \
COMP(sub_by_id), \
COMP(sub_by_total), \
COMP(sub_by_self), \
COMP(sub_by_name), \
COMP(kin_by_sub), \
COMP(kin_by_name), \
COMP(ptr_by_pos)

enum
{
#define COMP(X) CMP_ ## X
    TREE_COMPARISON_FUNCIONS
#undef COMP
};

/************************************************************
 * COL_X_POSITION
 *
 *   postscript column positions for code coverage report fields
 *
 ************************************************************/
typedef enum
{
    COL_NEXT = -1,
    COL_LINUM = 20,
    COL_ADDRESS = 62,
    COL_LOOP = 102,
    COL_CYCLE = 138,
    COL_PASS = 200,
    COL_SOURCE = 260
}
COL_X_POSITION;

#define MIN_2(A,B) ((A < B)? A : B)
#define MAX_2(A,B) ((A > B)? A : B)
#define MIN_4(A,B,C,D) MIN_2(MIN_2(A,B),MIN_2(C,D))
#define MAX_4(A,B,C,D) MAX_2(MAX_2(A,B),MAX_2(C,D))

#define PRG(FIELD) siml_rg_program->FIELD
#define SUBR(FIELD) siml_rg_program->sub.FIELD

#define SECTION_FILE(SECNUM) PRG (section_files)[SECNUM]
#define SECTION_NAME(SECNUM) PRG (section_names)[SECNUM]

#define BLANK_STRUCT(VAR, TYPE) memset (VAR, 0, sizeof (struct TYPE))
#define ERRMC(ERR_MSG_CODE) siml_rg_err_msg[(unsigned int) ERR_MSG_CODE]
#define CMD_SIZE(CMD) (((CMD)->attributes & IATR_TWO_WORD) ? 2 : 1)
#define SAME_INST(I1,I2) ((I1)->word1 == (I2)->word1 && \
 (CMD_SIZE(I1) == 1 || (I1)->word2 == (I2)->word2))
#define I_LINE(I) ((I)? I->source_line : -1)

#define CALL_SUB(INST) (INST)->call_sub
#define ENTER_SUB(INST) (INST)->enter_sub
#define ADD_CALL_POINT(SUB,INST) \
siml_rg_tree_insert((SUB)->rti_call_tree, INST, dup_NO)
#define ADD_ENTRY_POINT(SUB,INST) \
siml_rg_tree_insert((SUB)->rti_entry_tree, INST, dup_NO);

#define FREE(PTR) dsp_free_mem((char *) (PTR))
#define PERM_STRDUP(STRING) \
siml_rg_strdup(& siml_rg_program->mem_anchor, STRING)
#define TEMP_ALLOC(BYTES) (siml_rg_alloc(BYTES))
#define PERM_ALLOC(BYTES) \
(siml_rg_alloc_new_item (& siml_rg_program->mem_anchor, BYTES))
#define TEMP_NEW(TYPE) (struct TYPE *) (siml_rg_alloc(sizeof(struct TYPE)))
#define PERM_NEW(TYPE) (struct TYPE *) \
(siml_rg_alloc_new_item (& siml_rg_program->mem_anchor, sizeof(struct TYPE)))
#define NEW(TYPE) ((PRG(temp_mem) == TRUE)? TEMP_NEW(TYPE) : PERM_NEW(TYPE))

#define ADDRESS_MODE(GR,AM) PRG(report_info).address_mode[GR][AM]
#define ADD_MODE_MSG(GROUP, MODE) add_mode_msg[(GROUP)*AM_LAST_MODE + (MODE)]

#define PROF_FUNC(F) (*(sx_var->pft->F))
#define PROF_ARG(F) sx_var->pft->F

#endif /* __rgcom_h__ */
