#ifndef __DSK
#define __DSK
//---------------------------------------------------------
// DSK.H
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//---------------------------------------------------------
// Software version stamp for all apps goes here
//---------------------------------------------------------
#define  DSK3_ver	1.20
//---------------------------------------------------------
#include "typedefs.h"
#include "errormsg.h"
#include "typedefs.h"
#include "errormsg.h"

enum TARGET_TYPE{C31_DSK, C32_DSK, C30_EVM};

extern int   TARGET;
extern int   FAST_FLAG;
extern ulong SIZELOC; // printer port readback mode information here
extern ulong VECTLOC; // Location of vector table
extern ulong DASMBGN; // Startup DASM location
extern ulong STEPLOC; // SSTEP here for _dT constant
extern ulong SP_DFLT; // Default stack location for file reloading

//#define MAX_WAIT 100000L    //  3-10-97 bumped up for wav file buffer
extern long MAX_WAIT; // 100000L
//
// Prototypes and declarations for TARGET.CPP
//
// The DSK jump table is located at 0x809FF4 in DSP memory
// When an enumerated command is sent to the DSP the number
// value is used as an offset to lookup the address of the
// command to execute.  Since a table offset is used this
// also makes a convenient place to patch in the host routines
// with applications.  For expansion purposes a spare is also
// provided which the user can define.
//
#define XWRIT     1
#define XREAD     2
#define XCTXT     3
#define XRUNF     4
#define XSSTEP    5
#define XHALT     6
#define XW_HOST   7  /* Not really a host based command      */
#define XR_HOST   8  /* Not really a host based command      */
#define XSPARE    9  /* Need to add your own vector for this */

MSGS putmem  (ulong addr, ulong length, ulong *data);
MSGS getmem  (ulong addr, ulong length, ulong *data);
MSGS SSTEP_CPU     (void);
MSGS RUN_CPU       (void);
MSGS HALT_CPU      (void);
MSGS GET_DEBUG_CTXT(void);
extern int swap_en;
//
// Prototypes and declarations for DRIVER.CPP
//
extern uint  port  ;
extern uint  status;
extern uint  ctrl  ;
extern ulong WSHIFT ;
extern ulong WSCOUNT;
extern int   timeout;
extern int   test_flag;
extern char huge Help_Msg[];
extern char  LO_PWR;

void   whirly(int x,int y);
void   HPI_STRB(int val);
char   HPI_ACK(void);
MSGS   DSK_reset(void);
MSGS   Interlock(void);
MSGS   recv_long(ulong *);
MSGS   xmit_byte(char);
MSGS   xmit_long(ulong);
void   Pulse_Init(void);
//
// C31 DSK interface and parallel printer port signal definitions
// Bit definitions at printer control port (write)
//    B7      B6     B5    B4     B3        B2         B1        B0
// +--------------------+--------------+----------+---------+---------+
// |  DIR |   x  |  DIR |  INT |/SLCTIN|   INIT   |/AUTOFEED| /STROBE |
// +--------------------+--------------+----------+---------+---------+
//                                        RESET                 HPSTB
//                   W     R/W     W      R/W          W         R/W
//
// Bit definitions at printer status port (read)
//    B7         B6         B5          B4        B3     B2    B1   B0
// +----------+----------+-----------+----------+---------------------+
// | /BUSY    |  ACK     |  PAPER    |  SELECT  |ERROR| ACK |  x |  x |
// +----------+----------+-----------+----------+---------------------+
//  <------------------ D0 - D3 ---------------> HPACK
extern int _DIR;        // NOTE: Some laptops use these bits for shutdown!
#define PPSTRB_LO 0x5
#define PPSTRB_HI 0x4
#define RESET_LO 0x0    /* RESET is lo, PSTRB hi */
#define RESET_HI 0x4    /* RESET is hi, PSTRB hi */
#define outctrl(val)   outportb(ctrl,val)
#define instat         inportb(status)
#define inbyte         inportb(port)
#define innible        ((inportb(status) >> 4) ^ 0x8)
#define outbyte(val)   outportb(port,val)
#define inctrl         inportb(ctrl)
//
// The following enumeration matches the context save structure used
// in the communications kernel.  By downloading the context save area
// to PC memory (int the array CTXT[]) programs can have access to the
// DSP's registers.   By then modifying and reloading these values
// the user can modify the runtime parameters.
//
typedef enum { R0F, R1F, R2F, R3F, R4F, R5F, R6F, R7F, // R8i-11i  0- 7
               R0 , R1 , R2 , R3 , R4 , R5 , R6 , R7 , // R8F-11F  8-15
               AR0, AR1, AR2, AR3, AR4, AR5, AR6, AR7, //         16-24
               DP , IR0, IR1, BK , SP , ST , IE , IF , //         25-31
               IOF, RS ,  RE,  RC, PC , FREERUN, T1DIF, CNTXT //  32-38
             } TMS_REGS;

#define CTXTSIZE 39
extern ulong CTXT[];
//
// Prototypes and declarations for OBJECT.CPP
//
extern ulong ENTRY;
extern ulong PC_Appli;
extern ulong DEBUG_CTXT;
extern int   WINDOWS ;
extern int   timeout ;
extern int   BW_force;
extern int   Windows_Detected;
extern int   DSK3D;    // Global flag for low level code
extern int   No_MTask;

int  ports         (int base);
void enable_Mtask  (void);
void disable_Mtask (void);
void Release_TSlice(void);
MSGS Detect_Windows(void);
MSGS Scan_Command_line(char *app_name);
MSGS Display_manual   (char     *name);
MSGS View_Manual      (char     *name);
//
// Edit the hardware manual to have the name of the app and options
void Edit_Help_Msg(char *app_name, char *sw1, char *desc);
MSGS Init_Communication(int loops);
MSGS get_buswidth  (void);
MSGS set_buswidth  (void);
MSGS Disp_Menu(char *banner, char huge *msg,int,int,int,int);

#define FRAME2 "ɻȼ" /* Double bar frame  */
#define FRAME1 "ڿٳ" /* Single bar frame  */
#define FRAME0 "      " /* Plain text window */

extern float DSK3_rev; // Global version variable available to all apps

#endif
