/*

Freely Distributable C30 Simulator Package

Copyright (c) 1996-1997 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Authors: Chi Duong, Brian Evans, and Chris Moy
Version: @(#)byteswap.cc	1.2	08/22/97

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

/*
Check if we need to swap bytes as we read it the C30 program.
The PC orders bits from lowest to highest.  Sparc workstations
order bits from the highest to lowest.  We test for byte swapping
by storing an integer into a C30 word (an unsigned 32-bit location).
We then read the first byte of the C30 word.  The byte swapping
test is with respect to an IBM PC.
*/
int byteSwappedvsPC() {
    unsigned long c30word = 0x0102;
    unsigned char* highestByte = (unsigned char*)&c30word;
    return (*highestByte == 0);
}

/*
Perform byte swapping in a C30 word.
*/
unsigned long swapBytes(const unsigned long word) {
    unsigned long c30word;
    const unsigned char* wordBytePtr = (const unsigned char*)&word;
    unsigned char* c30wordBytePtr = (unsigned char*)&c30word;
    c30wordBytePtr[0] = wordBytePtr[3];
    c30wordBytePtr[1] = wordBytePtr[2];
    c30wordBytePtr[2] = wordBytePtr[1];
    c30wordBytePtr[3] = wordBytePtr[0];
    return c30word;
}
