--TEST--
FPM: bug68381 - Log messages with warning level only
--SKIPIF--
<?php
include "skipif.inc";
if (getenv("SKIP_ASAN")) die("skip Often fails on azure with asan for unknown reason");
?>
--FILE--
<?php

require_once "tester.inc";

$cfg = <<<EOT
[global]
error_log = {{FILE:LOG}}
log_level = warning
[unconfined]
listen = {{ADDR}}
pm = dynamic
pm.max_children = 5
pm.start_servers = 2
pm.min_spare_servers = 1
pm.max_spare_servers = 3
EOT;

$tester = new FPM\Tester($cfg);
$tester->start();
$tester->checkConnection();
$tester->terminate();
$tester->expectNoLogMessages();
$tester->close();

?>
Done
--EXPECT--
Done
--CLEAN--
<?php
require_once "tester.inc";
FPM\Tester::clean();
?>
