<?php

/** @generate-class-entries */

namespace Soap {
    /**
     * @strict-properties
     * @not-serializable
     */
    final class Url
    {
    }

    /**
     * @strict-properties
     * @not-serializable
     */
    final class Sdl
    {
    }
}

namespace {
    /**
     * @var int
     * @cvalue SOAP_1_1
     */
    const SOAP_1_1 = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_1_2
     */
    const SOAP_1_2 = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_PERSISTENCE_SESSION
     */
    const SOAP_PERSISTENCE_SESSION = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_PERSISTENCE_REQUEST
     */
    const SOAP_PERSISTENCE_REQUEST = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_FUNCTIONS_ALL
     */
    #[\Deprecated(since: '8.4', message: 'as enabling all functions is a possible security concern')]
    const SOAP_FUNCTIONS_ALL = UNKNOWN;

    /**
     * @var int
     * @cvalue SOAP_ENCODED
     */
    const SOAP_ENCODED = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_LITERAL
     */
    const SOAP_LITERAL = UNKNOWN;

    /**
     * @var int
     * @cvalue SOAP_RPC
     */
    const SOAP_RPC = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_DOCUMENT
     */
    const SOAP_DOCUMENT = UNKNOWN;

    /**
     * @var int
     * @cvalue SOAP_ACTOR_NEXT
     */
    const SOAP_ACTOR_NEXT = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_ACTOR_NONE
     */
    const SOAP_ACTOR_NONE = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_ACTOR_UNLIMATERECEIVER
     */
    const SOAP_ACTOR_UNLIMATERECEIVER = UNKNOWN;

    /**
     * @var int
     * @cvalue SOAP_COMPRESSION_ACCEPT
     */
    const SOAP_COMPRESSION_ACCEPT = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_COMPRESSION_GZIP
     */
    const SOAP_COMPRESSION_GZIP = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_COMPRESSION_DEFLATE
     */
    const SOAP_COMPRESSION_DEFLATE = UNKNOWN;

    /**
     * @var int
     * @cvalue SOAP_AUTHENTICATION_BASIC
     */
    const SOAP_AUTHENTICATION_BASIC = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_AUTHENTICATION_DIGEST
     */
    const SOAP_AUTHENTICATION_DIGEST = UNKNOWN;

    /**
     * @var int
     * @cvalue UNKNOWN_TYPE
     */
    const UNKNOWN_TYPE = UNKNOWN;

    /**
     * @var int
     * @cvalue XSD_STRING
     */
    const XSD_STRING = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_BOOLEAN
     */
    const XSD_BOOLEAN = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_DECIMAL
     */
    const XSD_DECIMAL = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_FLOAT
     */
    const XSD_FLOAT = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_DOUBLE
     */
    const XSD_DOUBLE = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_DURATION
     */
    const XSD_DURATION = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_DATETIME
     */
    const XSD_DATETIME = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_TIME
     */
    const XSD_TIME = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_DATE
     */
    const XSD_DATE = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_GYEARMONTH
     */
    const XSD_GYEARMONTH = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_GYEAR
     */
    const XSD_GYEAR = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_GMONTHDAY
     */
    const XSD_GMONTHDAY = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_GDAY
     */
    const XSD_GDAY = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_GMONTH
     */
    const XSD_GMONTH = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_HEXBINARY
     */
    const XSD_HEXBINARY = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_BASE64BINARY
     */
    const XSD_BASE64BINARY = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_ANYURI
     */
    const XSD_ANYURI = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_QNAME
     */
    const XSD_QNAME = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_NOTATION
     */
    const XSD_NOTATION = UNKNOWN;

    /**
     * @var int
     * @cvalue XSD_NORMALIZEDSTRING
     */
    const XSD_NORMALIZEDSTRING = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_TOKEN
     */
    const XSD_TOKEN = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_LANGUAGE
     */
    const XSD_LANGUAGE = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_NMTOKEN
     */
    const XSD_NMTOKEN = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_NAME
     */
    const XSD_NAME = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_NCNAME
     */
    const XSD_NCNAME = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_ID
     */
    const XSD_ID = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_IDREF
     */
    const XSD_IDREF = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_IDREFS
     */
    const XSD_IDREFS = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_ENTITY
     */
    const XSD_ENTITY = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_ENTITIES
     */
    const XSD_ENTITIES = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_INTEGER
     */
    const XSD_INTEGER = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_NONPOSITIVEINTEGER
     */
    const XSD_NONPOSITIVEINTEGER = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_NEGATIVEINTEGER
     */
    const XSD_NEGATIVEINTEGER = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_LONG
     */
    const XSD_LONG = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_INT
     */
    const XSD_INT = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_SHORT
     */
    const XSD_SHORT = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_BYTE
     */
    const XSD_BYTE = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_NONNEGATIVEINTEGER
     */
    const XSD_NONNEGATIVEINTEGER = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_UNSIGNEDLONG
     */
    const XSD_UNSIGNEDLONG = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_UNSIGNEDINT
     */
    const XSD_UNSIGNEDINT = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_UNSIGNEDSHORT
     */
    const XSD_UNSIGNEDSHORT = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_UNSIGNEDBYTE
     */
    const XSD_UNSIGNEDBYTE = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_POSITIVEINTEGER
     */
    const XSD_POSITIVEINTEGER = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_NMTOKENS
     */
    const XSD_NMTOKENS = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_ANYTYPE
     */
    const XSD_ANYTYPE = UNKNOWN;
    /**
     * @var int
     * @cvalue XSD_ANYXML
     */
    const XSD_ANYXML = UNKNOWN;

    /**
     * @var int
     * @cvalue APACHE_MAP
     */
    const APACHE_MAP = UNKNOWN;

    /**
     * @var int
     * @cvalue SOAP_ENC_OBJECT
     */
    const SOAP_ENC_OBJECT = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_ENC_ARRAY
     */
    const SOAP_ENC_ARRAY = UNKNOWN;

    /**
     * @var int
     * @cvalue XSD_1999_TIMEINSTANT
     */
    const XSD_1999_TIMEINSTANT = UNKNOWN;

    /**
     * @var string
     * @cvalue XSD_NAMESPACE
     */
    const XSD_NAMESPACE = UNKNOWN;
    /**
     * @var string
     * @cvalue XSD_1999_NAMESPACE
     */
    const XSD_1999_NAMESPACE = UNKNOWN;

    /**
     * @var int
     * @cvalue SOAP_SINGLE_ELEMENT_ARRAYS
     */
    const SOAP_SINGLE_ELEMENT_ARRAYS = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_WAIT_ONE_WAY_CALLS
     */
    const SOAP_WAIT_ONE_WAY_CALLS = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_USE_XSI_ARRAY_TYPE
     */
    const SOAP_USE_XSI_ARRAY_TYPE = UNKNOWN;

    /**
     * @var int
     * @cvalue WSDL_CACHE_NONE
     */
    const WSDL_CACHE_NONE = UNKNOWN;
    /**
     * @var int
     * @cvalue WSDL_CACHE_DISK
     */
    const WSDL_CACHE_DISK = UNKNOWN;
    /**
     * @var int
     * @cvalue WSDL_CACHE_MEMORY
     */
    const WSDL_CACHE_MEMORY = UNKNOWN;
    /**
     * @var int
     * @cvalue WSDL_CACHE_BOTH
     */
    const WSDL_CACHE_BOTH = UNKNOWN;

    /* New SOAP SSL Method Constants */

    /**
     * @var int
     * @cvalue SOAP_SSL_METHOD_TLS
     */
    const SOAP_SSL_METHOD_TLS = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_SSL_METHOD_SSLv2
     */
    const SOAP_SSL_METHOD_SSLv2 = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_SSL_METHOD_SSLv3
     */
    const SOAP_SSL_METHOD_SSLv3 = UNKNOWN;
    /**
     * @var int
     * @cvalue SOAP_SSL_METHOD_SSLv23
     */
    const SOAP_SSL_METHOD_SSLv23 = UNKNOWN;

    function use_soap_error_handler(bool $enable = true): bool {}

    function is_soap_fault(mixed $object): bool {}

    class SoapParam
    {
        public string $param_name;
        public mixed $param_data;

        public function __construct(mixed $data, string $name) {}
    }

    class SoapHeader
    {
        public string $namespace;
        public string $name;
        public mixed $data = null;
        public bool $mustUnderstand;
        public string|int|null $actor;

        public function __construct(string $namespace, string $name, mixed $data = UNKNOWN, bool $mustUnderstand = false, string|int|null $actor = null) {}
    }

    class SoapFault extends Exception
    {
        public string $faultstring;
        public ?string $faultcode = null;
        public ?string $faultcodens = null;
        public ?string $faultactor = null;
        public mixed $detail = null;
        public ?string $_name = null;
        public mixed $headerfault = null;
        public string $lang = "";

        public function __construct(array|string|null $code, string $string, ?string $actor = null, mixed $details = null, ?string $name = null, mixed $headerFault = null, string $lang = "") {}

        public function __toString(): string {}
    }

    class SoapVar
    {
        public int $enc_type;
        public mixed $enc_value = null;
        public ?string $enc_stype = null;
        public ?string $enc_ns = null;
        public ?string $enc_name = null;
        public ?string $enc_namens = null;

        public function __construct(mixed $data, ?int $encoding, ?string $typeName = null, ?string $typeNamespace = null, ?string $nodeName = null, ?string $nodeNamespace = null) {}
    }

    class SoapServer
    {
        private ?SoapFault $__soap_fault = null;

        public function __construct(?string $wsdl, array $options = []) {}

        /** @tentative-return-type */
        public function fault(string $code, string $string, string $actor = "", mixed $details = null, string $name = "", string $lang = ""): void {}

        /** @tentative-return-type */
        public function addSoapHeader(SoapHeader $header): void {}

        /** @tentative-return-type */
        public function setPersistence(int $mode): void {}

        /** @tentative-return-type */
        public function setClass(string $class, mixed ...$args): void {}

        /** @tentative-return-type */
        public function setObject(object $object): void {}

        /** @tentative-return-type */
        public function getFunctions(): array {}

        /**
         * @param array|string|int $functions
         * @tentative-return-type
         */
        public function addFunction($functions): void {}

        /** @tentative-return-type */
        public function handle(?string $request = null): void {}

        public function __getLastResponse(): ?string {}
    }

    class SoapClient
    {
        private ?string $uri = null;
        private ?int $style = null;
        private ?int $use = null;
        private ?string $location = null;
        private bool $trace = false;
        private ?int $compression = null;
        private ?Soap\Sdl $sdl = null;
        private ?array $typemap = null;
        /** @var resource|null */
        private $httpsocket = null;
        private ?Soap\Url $httpurl = null;

        private ?string $_login = null;
        private ?string $_password = null;
        private bool $_use_digest = false;
        private ?string $_digest = null;
        private ?string $_proxy_host = null;
        private ?int $_proxy_port = null;
        private ?string $_proxy_login = null;
        private ?string $_proxy_password = null;
        private bool $_exceptions = true;
        private ?string $_encoding = null;
        private ?array $_classmap = null;
        private ?int $_features = null;
        private int $_connection_timeout = 0;
        /** @var resource|null */
        private $_stream_context = null;
        private ?string $_user_agent = null;
        private bool $_keep_alive = true;
        private ?int $_ssl_method = null;
        private int $_soap_version;
        private ?int $_use_proxy = null;
        private array $_cookies = [];
        private ?array $__default_headers = null;
        private ?SoapFault $__soap_fault = null;
        private ?string $__last_request = null;
        private ?string $__last_response = null;
        private ?string $__last_request_headers = null;
        private ?string $__last_response_headers = null;

        public function __construct(?string $wsdl, array $options = []) {}

        /** @tentative-return-type */
        public function __call(string $name, array $args): mixed {}

        /**
         * @param SoapHeader|array|null $inputHeaders
         * @param array $outputHeaders
         * @tentative-return-type
         */
        public function __soapCall(string $name, array $args, ?array $options = null, $inputHeaders = null, &$outputHeaders = null): mixed {}

        /** @tentative-return-type */
        public function __getFunctions(): ?array {}

        /** @tentative-return-type */
        public function __getTypes(): ?array {}

        /** @tentative-return-type */
        public function __getLastRequest(): ?string {}

        /** @tentative-return-type */
        public function __getLastResponse(): ?string {}

        /** @tentative-return-type */
        public function __getLastRequestHeaders(): ?string {}

        /** @tentative-return-type */
        public function __getLastResponseHeaders(): ?string {}

        /** @tentative-return-type */
        public function __doRequest(string $request, string $location, string $action, int $version, bool $oneWay = false, ?string $uriParserClass = null): ?string {}

        /** @tentative-return-type */
        public function __setCookie(string $name, ?string $value = null): void {}

        /** @tentative-return-type */
        public function __getCookies(): array {}

        /**
         * @param SoapHeader|array|null $headers
         * @tentative-return-type
         */
        public function __setSoapHeaders($headers = null): bool {}

        /** @tentative-return-type */
        public function __setLocation(?string $location = null): ?string {}
    }
}
